package xyz.nuark.bgopt

import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.os.PowerManager
import android.provider.Settings
import android.util.Log
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import xyz.nuark.bgopt.databinding.ActivityMainBinding
import java.util.Timer
import java.util.TimerTask

class MainActivity : AppCompatActivity() {
    private lateinit var binding: ActivityMainBinding
    private val timer = Timer()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()

        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main)) { v, insets ->
            val systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars())
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom)
            insets
        }

        binding.requestOpt.setOnClickListener {
            batteryOptimization()
        }

        timer.schedule(object : TimerTask() {
            override fun run() {
                val opt = checkBatteryOptimization()

                binding.root.post {
                    if (opt) {
                        binding.optStatus.text = "Optimization is disabled"
                    } else {
                        binding.optStatus.text = "Optimization is enabled"
                    }
                }
            }
        }, 0, 1000)
    }

    fun batteryOptimization() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val packageName: String? = getPackageName()
            val powerManager: PowerManager = getSystemService(POWER_SERVICE) as PowerManager

            if (!powerManager.isIgnoringBatteryOptimizations(packageName)) {
                try {
                    val intent = Intent()
                    intent.setAction(Settings.ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS)
                    intent.setData(Uri.parse("package:" + packageName))
                    startActivity(intent)
                } catch (e: Exception) {
                    Log.e("BatteryOpt", "Error excluding app from battery optimization", e)
                }
            } else {
                Log.d("BatteryOpt", "App already excluded from battery optimization")
            }
        }
    }

    fun checkBatteryOptimization(): Boolean {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val powerManager: PowerManager = getSystemService(POWER_SERVICE) as PowerManager
            val isIgnoringBattery: Boolean =
                powerManager.isIgnoringBatteryOptimizations(getPackageName())
            Log.d("BatteryOpt", "Exclusion of battery optimization: " + isIgnoringBattery)

            isIgnoringBattery
        } else {
            Log.d("BatteryOpt", "No battery optimization")
            false
        }
    }
}